/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ShulkerModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import xyz.przemyk.simpleplanes.client.render.ParachuteRenderer;
import xyz.przemyk.simpleplanes.client.render.PlaneRenderer;
import xyz.przemyk.simpleplanes.client.render.UpgradesModels;
import xyz.przemyk.simpleplanes.client.render.models.HelicopterModel;
import xyz.przemyk.simpleplanes.client.render.models.HelicopterPropellerModel;
import xyz.przemyk.simpleplanes.client.render.models.LargePlaneModel;
import xyz.przemyk.simpleplanes.client.render.models.ParachuteModel;
import xyz.przemyk.simpleplanes.client.render.models.PlaneModel;
import xyz.przemyk.simpleplanes.client.render.models.PropellerModel;
import xyz.przemyk.simpleplanes.entities.LargePlaneEntity;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.setup.SimplePlanesEntities;
import xyz.przemyk.simpleplanes.upgrades.armor.ArmorModel;
import xyz.przemyk.simpleplanes.upgrades.armor.LargeArmorModel;
import xyz.przemyk.simpleplanes.upgrades.booster.BoosterModel;
import xyz.przemyk.simpleplanes.upgrades.floating.FloatingModel;
import xyz.przemyk.simpleplanes.upgrades.floating.HelicopterFloatingModel;
import xyz.przemyk.simpleplanes.upgrades.floating.LargeFloatingModel;
import xyz.przemyk.simpleplanes.upgrades.seats.SeatsUpgradeModel;
import xyz.przemyk.simpleplanes.upgrades.shooter.ShooterModel;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class PlanesModelLayers {
    public static final ModelLayerLocation PLANE_LAYER = new ModelLayerLocation(new ResourceLocation("simpleplanes", "plane"), "main");
    public static final ModelLayerLocation LARGE_PLANE_LAYER = new ModelLayerLocation(new ResourceLocation("simpleplanes", "large_plane"), "main");
    public static final ModelLayerLocation HELICOPTER_LAYER = new ModelLayerLocation(new ResourceLocation("simpleplanes", "helicopter"), "main");
    public static final ModelLayerLocation PROPELLER_LAYER = new ModelLayerLocation(new ResourceLocation("simpleplanes", "propeller"), "main");
    public static final ModelLayerLocation HELICOPTER_PROPELLER_LAYER = new ModelLayerLocation(new ResourceLocation("simpleplanes", "helicopter_propeller"), "main");
    public static final ModelLayerLocation PARACHUTE_LAYER = new ModelLayerLocation(new ResourceLocation("simpleplanes", "parachute"), "main");
    public static final ModelLayerLocation BOOSTER = new ModelLayerLocation(new ResourceLocation("simpleplanes", "booster"), "main");
    public static final ModelLayerLocation SHOOTER = new ModelLayerLocation(new ResourceLocation("simpleplanes", "shooter"), "main");
    public static final ModelLayerLocation FLOATING = new ModelLayerLocation(new ResourceLocation("simpleplanes", "floating"), "main");
    public static final ModelLayerLocation LARGE_FLOATING = new ModelLayerLocation(new ResourceLocation("simpleplanes", "large_floating"), "main");
    public static final ModelLayerLocation HELICOPTER_FLOATING = new ModelLayerLocation(new ResourceLocation("simpleplanes", "helicopter_floating"), "main");
    public static final ModelLayerLocation ARMOR = new ModelLayerLocation(new ResourceLocation("simpleplanes", "armor"), "main");
    public static final ModelLayerLocation LARGE_ARMOR = new ModelLayerLocation(new ResourceLocation("simpleplanes", "large_armor"), "main");
    public static final ModelLayerLocation SEATS = new ModelLayerLocation(new ResourceLocation("simpleplanes", "seats"), "main");

    @SubscribeEvent
    public static void registerLayer(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(PLANE_LAYER, PlaneModel::createBodyLayer);
        event.registerLayerDefinition(LARGE_PLANE_LAYER, LargePlaneModel::createBodyLayer);
        event.registerLayerDefinition(HELICOPTER_LAYER, HelicopterModel::createBodyLayer);
        event.registerLayerDefinition(PROPELLER_LAYER, PropellerModel::createBodyLayer);
        event.registerLayerDefinition(HELICOPTER_PROPELLER_LAYER, HelicopterPropellerModel::createBodyLayer);
        event.registerLayerDefinition(PARACHUTE_LAYER, ParachuteModel::createBodyLayer);
        event.registerLayerDefinition(BOOSTER, BoosterModel::createBodyLayer);
        event.registerLayerDefinition(SHOOTER, ShooterModel::createBodyLayer);
        event.registerLayerDefinition(FLOATING, FloatingModel::createBodyLayer);
        event.registerLayerDefinition(LARGE_FLOATING, LargeFloatingModel::createBodyLayer);
        event.registerLayerDefinition(HELICOPTER_FLOATING, HelicopterFloatingModel::createBodyLayer);
        event.registerLayerDefinition(SEATS, SeatsUpgradeModel::createBodyLayer);
        event.registerLayerDefinition(ARMOR, ArmorModel::createBodyLayer);
        event.registerLayerDefinition(LARGE_ARMOR, LargeArmorModel::createBodyLayer);
    }

    @SubscribeEvent
    public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        EntityModelSet entityModelSet = Minecraft.m_91087_().m_167973_();
        event.registerEntityRenderer((EntityType)SimplePlanesEntities.PLANE.get(), context -> new PlaneRenderer<PlaneEntity>(context, new PlaneModel(entityModelSet.m_171103_(PLANE_LAYER)), new PropellerModel(entityModelSet.m_171103_(PROPELLER_LAYER)), 0.6f));
        event.registerEntityRenderer((EntityType)SimplePlanesEntities.LARGE_PLANE.get(), context -> new PlaneRenderer<LargePlaneEntity>(context, new LargePlaneModel(entityModelSet.m_171103_(LARGE_PLANE_LAYER)), new PropellerModel(entityModelSet.m_171103_(PROPELLER_LAYER)), 1.0f));
        event.registerEntityRenderer((EntityType)SimplePlanesEntities.HELICOPTER.get(), context -> new PlaneRenderer<PlaneEntity>(context, new HelicopterModel(entityModelSet.m_171103_(HELICOPTER_LAYER)), new HelicopterPropellerModel(entityModelSet.m_171103_(HELICOPTER_PROPELLER_LAYER)), 0.6f));
        event.registerEntityRenderer((EntityType)SimplePlanesEntities.PARACHUTE.get(), context -> new ParachuteRenderer(context, new ParachuteModel(entityModelSet.m_171103_(PARACHUTE_LAYER))));
    }

    @SubscribeEvent
    public static void bakeModelLayers(EntityRenderersEvent.AddLayers event) {
        EntityModelSet entityModelSet = event.getEntityModels();
        UpgradesModels.BOOSTER = new BoosterModel(entityModelSet.m_171103_(BOOSTER));
        UpgradesModels.SHOOTER = new ShooterModel(entityModelSet.m_171103_(SHOOTER));
        UpgradesModels.FLOATING = new FloatingModel(entityModelSet.m_171103_(FLOATING));
        UpgradesModels.LARGE_FLOATING = new LargeFloatingModel(entityModelSet.m_171103_(LARGE_FLOATING));
        UpgradesModels.HELICOPTER_FLOATING = new HelicopterFloatingModel(entityModelSet.m_171103_(HELICOPTER_FLOATING));
        UpgradesModels.ARMOR = new ArmorModel(entityModelSet.m_171103_(ARMOR));
        UpgradesModels.LARGE_ARMOR = new LargeArmorModel(entityModelSet.m_171103_(LARGE_ARMOR));
        UpgradesModels.SHULKER_FOLDING = new ShulkerModel(entityModelSet.m_171103_(ModelLayers.f_171180_));
        UpgradesModels.SEATS = new SeatsUpgradeModel(entityModelSet.m_171103_(SEATS));
    }
}

